// Copyright 2014 Google Inc. All Rights Reserved.

#include "SemaphoreWrapper.h"

Semaphore::Semaphore() {
    sem_init(&mSem, 0, 0);
}

Semaphore::Semaphore(int value) {
    sem_init(&mSem, 0, value);
}

Semaphore::~Semaphore() {
    sem_destroy(&mSem);
}

bool Semaphore::down() {
    return (sem_wait(&mSem) == 0);
}

bool Semaphore::up() {
    return (sem_post(&mSem) == 0);
}

